/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures;

import com.telepathicgrunt.repurposedstructures.configs.RSModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.misc.lootmanager.EndRemasteredDedicatedLoot;
import com.telepathicgrunt.repurposedstructures.misc.lootmanager.StructureModdedLootImporter;
import com.telepathicgrunt.repurposedstructures.misc.maptrades.StructureMapManager;
import com.telepathicgrunt.repurposedstructures.misc.maptrades.StructureMapTradesEvents;
import com.telepathicgrunt.repurposedstructures.misc.mobspawners.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.misc.pooladditions.PoolAdditionMerger;
import com.telepathicgrunt.repurposedstructures.misc.structurepiececounter.StructurePieceCountsManager;
import com.telepathicgrunt.repurposedstructures.modinit.RSFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSPlacements;
import com.telepathicgrunt.repurposedstructures.modinit.RSPredicates;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructurePlacementType;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSTags;
import com.telepathicgrunt.repurposedstructures.utils.AsyncLocator;
import com.telepathicgrunt.repurposedstructures.world.biomemodifiers.BiomeModifier;
import eu.midnightdust.lib.config.MidnightConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RepurposedStructures
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "repurposed_structures";
    public static MobSpawnerManager mobSpawnerManager = new MobSpawnerManager();
    public static StructureMapManager structureMapManager = new StructureMapManager();
    public static StructurePieceCountsManager structurePieceCountsManager = new StructurePieceCountsManager();

    public void onInitialize() {
        MidnightConfig.init((String)MODID, RSModdedLootConfig.class);
        RSTags.initTags();
        RSFeatures.registerFeatures();
        RSPlacements.registerPlacements();
        RSProcessors.registerProcessors();
        RSPredicates.registerPredicates();
        RSStructures.registerStructures();
        RSStructurePlacementType.registerStructurePlacementTypes();
        RepurposedStructures.setupBiomeModifications();
        PoolAdditionMerger.mergeAdditionPools();
        StructureMapTradesEvents.setupTradeEvent();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)mobSpawnerManager);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)structureMapManager);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)structurePieceCountsManager);
        EndRemasteredDedicatedLoot.isEndRemasteredOn = FabricLoader.getInstance().isModLoaded("endrem");
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                StructureModdedLootImporter.checkLoottables(minecraftServer);
                EndRemasteredDedicatedLoot.checkLoottables(minecraftServer);
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(s -> AsyncLocator.handleServerAboutToStartEvent());
        ServerLifecycleEvents.SERVER_STOPPING.register(s -> AsyncLocator.handleServerStoppingEvent());
    }

    public static void setupBiomeModifications() {
        BiomeModifier.addFeatures();
    }
}

